



/* This file contains apis related to i2c */

/* Standard includes */
#include "FT_Platform.h"
#include "..\Wire\Wire.h"
#if 0
#include "FT_DataTypes.h"
#include "FT_Gpu.h"
#ifdef ARDUINO_PLATFORM
#include <stdio.h>
#include <Arduino.h>
#include <SPI.h>
#include <avr/pgmspace.h>
#include <Wire.h>
#endif
#endif
#include "FT_Hal_I2C.h"

/* mainly assosiated to rtc - need to make it generic */



ft_int16_t hal_rtc_i2c_init()
{
  Wire.begin();
  ft_delay(100);  
  return 0;
}

/* api to read n bytes from addr */
ft_int16_t hal_rtc_i2c_read(ft_uint8_t addr, ft_uint8_t *buffer,ft_uint16_t length)
{
  ft_uint16_t i;
  short count = 0;
  ft_uint8_t writeResult = 0;
   while (length > FT_ATMEGA328P_I2C_BURST_SIZE)
  {
    hal_rtc_i2c_read(addr,buffer,FT_ATMEGA328P_I2C_BURST_SIZE);
    buffer += FT_ATMEGA328P_I2C_BURST_SIZE;
    addr += FT_ATMEGA328P_I2C_BURST_SIZE;
    length -= FT_ATMEGA328P_I2C_BURST_SIZE;
  }
  
  Wire.beginTransmission(FT_ATMEGA328P_RTC_I2C_ADDRESS); // transmit to device (0x23)
  
 /* address bytes for rtc are from 00 to 0xff */
  Wire.write(addr);        // sends value byte  
  
  /* end the transmission but do not release the bus - usage is random data read use case from rtc */
  writeResult = Wire.endTransmission(false);//hold the bus to read the next data

  if (0 != writeResult)
  {
    return -1;//error case
  }

  Wire.requestFrom(FT_ATMEGA328P_RTC_I2C_ADDRESS, length);// request length bytes from slave device and end the transmission after this
  for(i=0;i<length;i++)
  {
    /* need to consider timout here */
    while(0 == Wire.available());//blocking call - at least one byte must be available
    buffer[i] = Wire.read();
  }
  
  return 0;
}

/* API to write data into particular location */
ft_int16_t hal_rtc_i2c_write(ft_uint8_t addr, ft_uint8_t *buffer,ft_uint16_t length)
{
  ft_uint16_t i;
  byte writeResult = 0;
  if(0 == length)
  {
    return -1;
  }
  
  /* for read the lower bit must be set to 1 and for write set to 0 */
  Wire.beginTransmission(FT_ATMEGA328P_RTC_I2C_ADDRESS);

  /* address bytes for rtc are from 00 to 0xff */
  Wire.write(addr);        // sends value byte  
  
  /* check for each byte */
  for(i=0;i<length;i++)
  {
    Wire.write(*buffer++);//send the data to slave
  }

  /* end the transmission by stop bit */
  
  writeResult = Wire.endTransmission();//end the transmission by setting the stop bit
  
  if(0 != writeResult)
  {
    return writeResult;
  }
  return 0;
}





/* Nothing beyond this */




